@ECHO OFF
SET APP_JVM_HOME=..\jvm
SET AUA_JVM_HOME=.\jvm
SET JVM_HOME=%APP_JVM_HOME%
IF "%~4"=="MIGRATE" (
  ECHO Use JVM home in AUA folder for migration
  SET JVM_HOME=%AUA_JVM_HOME%
) ELSE (
  IF NOT "%~4"=="" (
    ECHO Use custom JVM home in AUA folder for migration
    SET JVM_HOME="%~4"
  )
)

IF NOT Exist "%JVM_HOME%\bin\javau.exe" (
  ECHO Copy from %JVM_HOME%\bin\java.exe to %JVM_HOME%\bin\javau.exe
  copy %JVM_HOME%\bin\java.exe %JVM_HOME%\bin\javau.exe
)

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "DEP_LIB_PATH=X86"
) ELSE (
  SET "DEP_LIB_PATH=X64"
)
SET JAVA_LIB_PATH=-Djava.library.path=.\lib;.\lib\%DEP_LIB_PATH%

ECHO Start update application process
%JVM_HOME%\bin\javau %JAVA_LIB_PATH% -cp .\lib;.\lib\aopalliance-repackaged-2.6.1.jar;.\lib\aua.jar;.\lib\bcmail-jdk15to18-164.jar;.\lib\bcpkix-jdk15to18-164.jar;.\lib\bcprov-jdk15to18-164.jar;.\lib\commons-logging-1.2.1.jar;.\lib\hk2-api-2.6.1.jar;.\lib\hk2-locator-2.6.1.jar;.\lib\hk2-utils-2.6.1.jar;.\lib\httpclient-4.5.12.jar;.\lib\httpcore-4.4.13.jar;.\lib\jackson-annotations-2.12.4.jar;.\lib\jackson-core-2.12.4.jar;.\lib\jackson-databind-2.12.4.jar;.\lib\jackson-module-jaxb-annotations-2.12.4.jar;.\lib\jakarta.activation-api-1.2.2.jar;.\lib\jakarta.annotation-api-1.3.5.jar;.\lib\jakarta.inject-2.6.1.jar;.\lib\jakarta.validation-api-2.0.2.jar;.\lib\jakarta.ws.rs-api-2.1.6.jar;.\lib\jakarta.xml.bind-api-2.3.3.jar;.\lib\javassist-3.25.0-GA.jar;.\lib\jdom-1.1.3.jar;.\lib\jersey-client-2.34.jar;.\lib\jersey-common-2.34.jar;.\lib\jersey-container-servlet-core-2.34.jar;.\lib\jersey-entity-filtering-2.34.jar;.\lib\jersey-hk2-2.34.jar;.\lib\jersey-media-json-jackson-2.34.jar;.\lib\jersey-media-multipart-2.34.jar;.\lib\jersey-server-2.34.jar;.\lib\mimepull-1.9.13.jar;.\lib\org.json-20150730.jar;.\lib\osgi-resource-locator-1.0.3.jar;.\lib\snappy-java-1.1.7.3.jar;.\lib\sqlite-jdbc-3.27.2.1.1.jar -Xrs -Xmx128m AuaI %1 %2 %~3
IF NOT "%ERRORLEVEL%"=="0" (
  ECHO Update not completed, terminate now
  exit 0
)
IF "%~3"=="UI" (
  REM Do not ECHO message here since it will cause UI not started
  cd ..\bin
  IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    START SystemTray64.exe -UI
  ) ELSE (
    IF "%PROCESSOR_ARCHITECTURE%"=="x64" (
      START SystemTray64.exe -UI
    ) ELSE (
      START SystemTray.exe -UI
    )
  )
)
