@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

SET "APP_BIN=%~1"
SET "SERVICE_UTIL=%~2"

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"

SET /A "RTN_CODE=0"

REM Define the service
SET "CONTROL_VERSION=1.0"
SET "DESCRIPTION=Virtual File System Driver "
SET "SERVICE_DESCRIPTION=%DESCRIPTION%%CONTROL_VERSION%"

REM WinXP
SET "WIN_VER=5.1"
SET "SERVICE_VER=0.6.0"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK52
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK52
REM WinXP64, Server2003, Server2003R2
SET "WIN_VER=5.2"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK60
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK60
REM WinVista, Server2008
SET "WIN_VER=6.0"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK61
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK61
REM Win7, Server2008R2
SET "WIN_VER=6.1"
SET "SERVICE_VER=1.0.1"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK62
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK62
REM Win8, Server2012
SET "WIN_VER=6.2"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK63
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK63
REM Win8.1, Server2012R2
SET "WIN_VER=6.3"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECK100
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK100
REM Win10, Server2016
SET "WIN_VER=10.0"
VER | FIND "%WIN_VER%" > NUL
IF ERRORLEVEL = 1 GOTO _CHECKFAILED
IF ERRORLEVEL = 0 GOTO _CHECKED

:_CHECKFAILED
ECHO.This version of Windows is not supported!
SET /A "RTN_CODE=1"
GOTO _exit

:_CHECKED
IF "%WIN_VER%"=="" (
    ECHO.This version of Windows is not supported!
    SET /A "RTN_CODE=1"
    GOTO _exit
)

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "OS_ARCH=X86"
) ELSE (
    SET "OS_ARCH=X64"
)
SET "JNI_SOURCE_PATH=%CD%\%OS_ARCH%\jdokan.dll"
SET "SERVICE_EXEC=dokan1.sys"
SET "SERVICE_INF=dokan.inf"
SET "SERVICE_NAME=dokan1"
SET "SERVICE_DISPLAY_NAME=%SERVICE_NAME% %SERVICE_VER% Driver"
SET "SERVICE_SOURCE_PATH=%CD%\%OS_ARCH%\%WIN_VER%\%SERVICE_EXEC%"
SET "SERVICE_INSTALL_PATH=%SYSTEMROOT%\system32\drivers\%SERVICE_EXEC%"
SET "SERVICE_INF_PATH=%CD%\%OS_ARCH%\%WIN_VER%\%SERVICE_INF%"
SET "LIBRARY_EXEC=dokan1.dll"
SET "LIBRARY_SOURCE_PATH=%CD%\%OS_ARCH%\%WIN_VER%\%LIBRARY_EXEC%"
SET "LIBRARY_INSTALL_PATH=%SYSTEMROOT%\system32\%LIBRARY_EXEC%"

ECHO.
ECHO.CTRL VERSION : %CONTROL_VERSION%
ECHO.DESCRIPTION  : %SERVICE_DESCRIPTION%
ECHO.
ECHO.JNI PATH         : %JNI_SOURCE_PATH%
ECHO.WIN_VER      : %WIN_VER%
ECHO.NAME         : %SERVICE_NAME%
ECHO.DISPLAY NAME : %SERVICE_DISPLAY_NAME%
ECHO.PATH         : %SERVICE_SOURCE_PATH%
ECHO.INSTALL PATH : %SERVICE_INSTALL_PATH%
ECHO.LIB PATH         : %LIBRARY_SOURCE_PATH%
ECHO.LIB INSTALL PATH : %LIBRARY_INSTALL_PATH%
ECHO.INF PATH : %SERVICE_INF_PATH%
ECHO.

IF NOT EXIST "%JNI_SOURCE_PATH%" (
    ECHO.JNI is missing. This version of Windows is not supported!
    SET /A "RTN_CODE=1"
    GOTO _exit
)
IF NOT EXIST "%SERVICE_SOURCE_PATH%" (
    ECHO.Driver is missing. This version of Windows is not supported!
    SET /A "RTN_CODE=1"
    GOTO _exit
)
IF NOT EXIST "%LIBRARY_SOURCE_PATH%" (
    ECHO.Library is missing. This version of Windows is not supported!
    SET /A "RTN_CODE=1"
    GOTO _exit
)
IF NOT EXIST "%SERVICE_INF_PATH%" (
    ECHO.Driver is missing. This version of Windows is not supported!
    SET /A "RTN_CODE=1"
    GOTO _exit
)

SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" already running
    SET /A "RTN_CODE=0"
    GOTO _exit
)

SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF %STATE_INSTALL% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" is not running
    GOTO _start
)

REM Install service
IF EXIST "%LIBRARY_INSTALL_PATH%" (
    DEL /F /Q "%LIBRARY_INSTALL_PATH%"
)
COPY /V /Y /B "%LIBRARY_SOURCE_PATH%" /B "%LIBRARY_INSTALL_PATH%" /B
IF NOT EXIST "%LIBRARY_INSTALL_PATH%" (
    ECHO.Fail to copy file to "%LIBRARY_INSTALL_PATH%"
    SET /A "RTN_CODE=1"
    GOTO _exit
)
IF EXIST "%SERVICE_INSTALL_PATH%" (
    DEL /F /Q "%SERVICE_INSTALL_PATH%"
)
REM COPY /V /Y /B "%SERVICE_SOURCE_PATH%" /B "%SERVICE_INSTALL_PATH%" /B
REM IF NOT EXIST "%SERVICE_INSTALL_PATH%" (
REM     ECHO.Fail to copy file to "%SERVICE_INSTALL_PATH%"
REM     SET /A "RTN_CODE=1"
REM     GOTO _exit
REM )
ECHO.Create service "%SERVICE_NAME%"...
REM sc create "%SERVICE_NAME%" type= kernel start= auto error= ignore binpath= "%SERVICE_INSTALL_PATH%" DisplayName= "%SERVICE_DISPLAY_NAME%"
REM rundll32 syssetup,SetupInfObjectInstallAction DefaultInstall 128 %SERVICE_INF_PATH%
rundll32 setupapi.dll,InstallHinfSection DefaultInstall 132 %SERVICE_INF_PATH%
SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF NOT %STATE_INSTALL% EQU 1 (
    ECHO.Failed to create service "%SERVICE_NAME%"
    SET /A "RTN_CODE=1"
    GOTO _exit
)
sc description "%SERVICE_NAME%" "%SERVICE_DESCRIPTION%"

:_start
REM Start service
ECHO.Start service "%SERVICE_NAME%"...
sc start "%SERVICE_NAME%"

REM Check if service running
SET /A WAIT_STATUS_UPDATED_COUNT=1
:_check_running
SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" already running
    SET /A "RTN_CODE=0"
    GOTO _exit
)
IF %WAIT_STATUS_UPDATED_COUNT% GEQ 30 (
    ECHO.Service "%SERVICE_NAME%" is not running after installation
    SET /A "RTN_CODE=1"
    GOTO _exit
)
CALL :sub_sleep1s
SET /A WAIT_STATUS_UPDATED_COUNT+=1
GOTO _check_running

:_exit
CD "%EXE_HOME%"
EXIT /B %RTN_CODE%

REM ----------------------------------------------------------
:sub_sleep1s
PING -n 2 127.0.0.1>nul 
EXIT /B

:sub_print_status
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qs %~1"') DO (
    SET /A "FOUND=1"
    ECHO.    ^> %%i
)
IF %FOUND% EQU 1 (
    FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qc %~1"') DO (
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "PATH_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DISPLAY_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DESCRIPTION"') DO (
            ECHO.    ^> %%i
        )
    )
)
EXIT /B

:sub_check_installed
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    REM all service states start with "SERVICE_"
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

:sub_check_running
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_RUNNING" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

ENDLOCAL