@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"
SET "APP_BIN=%CD%"
CD ".."
SET "APP_HOME=%CD%"
CD "%~dp0"
SET "SERVICE_UTIL=%APP_HOME%\util\bin\Service.exe"
IF NOT EXIST "%SERVICE_UTIL%" (
    SET "SERVICE_UTIL=%APP_BIN%\Service.exe"
    IF NOT EXIST "!SERVICE_UTIL!" (
        ECHO."No Service.exe could be found!"
        SET /A "RTN_CODE=1"
        GOTO _exit
    )
)

SET /A "RTN_CODE=0"

REM Define the service
SET "CONTROL_VERSION=1.0"
SET "DESCRIPTION=VMDK / VHD Mount Driver "
SET "SERVICE_DESCRIPTION=%DESCRIPTION%%CONTROL_VERSION%"

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "OS_ARCH=X86"
    SET "SERVICE_EXEC=vstor2-mntapi10-shared.sys"
    SET "SERVICE_NAME=vstor2-mntapi10-shared"
    SET "SERVICE_DISPLAY_NAME=Vstor2 MntApi 1.0 Driver (shared)"
) ELSE (
    SET "OS_ARCH=X64"
    SET "SERVICE_EXEC=vstor2-mntapi20-shared.sys"
    SET "SERVICE_NAME=vstor2-mntapi20-shared"
    SET "SERVICE_DISPLAY_NAME=Vstor2 MntApi 2.0 Driver (shared)"
)
SET "SERVICE_SOURCE_PATH=%CD%\%OS_ARCH%\%SERVICE_EXEC%"
SET "SERVICE_INSTALL_PATH=%SYSTEMROOT%\system32\drivers\%SERVICE_EXEC%"

ECHO.
ECHO.CTRL VERSION : %CONTROL_VERSION%
ECHO.DESCRIPTION  : %SERVICE_DESCRIPTION%
ECHO.
ECHO.NAME         : %SERVICE_NAME%
ECHO.DISPLAY NAME : %SERVICE_DISPLAY_NAME%
ECHO.PATH         : %SERVICE_SOURCE_PATH%
ECHO.INSTALL PATH : %SERVICE_INSTALL_PATH%
ECHO.

IF NOT EXIST "%SERVICE_SOURCE_PATH%" (
    ECHO."This version of Windows is not supported!"
    SET /A "RTN_CODE=1"
    GOTO _exit
)

SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" already running
    SET /A "RTN_CODE=0"
    GOTO _exit
)

SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF %STATE_INSTALL% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" is not running
    GOTO _start
)

REM Install service
ECHO.Create service "%SERVICE_NAME%"...
IF EXIST "%SERVICE_INSTALL_PATH%" (
    DEL /F /Q "%SERVICE_INSTALL_PATH%"
)
COPY /V /Y /B "%SERVICE_SOURCE_PATH%" /B "%SERVICE_INSTALL_PATH%" /B
IF NOT EXIST "%SERVICE_INSTALL_PATH%" (
    ECHO.Fail to copy file to "%SERVICE_SOURCE_PATH%"
    SET /A "RTN_CODE=1"
    GOTO _exit
)
sc create "%SERVICE_NAME%" type= kernel start= auto error= normal binpath= "%SERVICE_INSTALL_PATH%" DisplayName= "%SERVICE_DISPLAY_NAME%" group= System
SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF NOT %STATE_INSTALL% EQU 1 (
    ECHO.Failed to create service "%SERVICE_NAME%"
    SET /A "RTN_CODE=1"
    GOTO _exit
)
sc description "%SERVICE_NAME%" "%SERVICE_DESCRIPTION%"

:_start
REM Start service
ECHO.Start service "%SERVICE_NAME%"...
sc start "%SERVICE_NAME%"

REM Check if service running
SET /A WAIT_STATUS_UPDATED_COUNT=1
:_check_running
SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" already running
    SET /A "RTN_CODE=0"
    GOTO _exit
)
IF %WAIT_STATUS_UPDATED_COUNT% GEQ 30 (
    ECHO.Service "%SERVICE_NAME%" is not running after installation
    SET /A "RTN_CODE=1"
    GOTO _exit
)
CALL :sub_sleep1s
SET /A WAIT_STATUS_UPDATED_COUNT+=1
GOTO _check_running

:_exit
CD "%EXE_HOME%"
EXIT /B %RTN_CODE%

REM ----------------------------------------------------------
:sub_sleep1s
PING -n 2 127.0.0.1>nul 
EXIT /B

:sub_print_status
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qs %~1"') DO (
    SET /A "FOUND=1"
    ECHO.    ^> %%i
)
IF %FOUND% EQU 1 (
    FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qc %~1"') DO (
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "PATH_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DISPLAY_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DESCRIPTION"') DO (
            ECHO.    ^> %%i
        )
    )
)
EXIT /B

:sub_check_installed
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    REM all service states start with "SERVICE_"
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

:sub_check_running
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_RUNNING" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

ENDLOCAL