#!/bin/sh
# This is a script file to be executed after installation
###############################################################################
#         I N S T A L L         S C H E D U L E R          S E R V I C E      #
###############################################################################

# APP_HOME="/Applications/netpartOBM.app"
SCRIPT_HOME="`dirname \"${0}\"`"
cd "${SCRIPT_HOME}"
# get APP_HOME from path of this script
APP_HOME="`pwd | sed -E -e \"s:(/[^/]*/[^/]*)/.*:\1:g\"`"

# remove existing aua service since it is already merged in v7
# Remove AutoUpdateAgent
if [ -e "/Library/StartupItems/netpartOBM-AutoUpdate" ]; then
    echo "Remove AutoUpdateAgent for netpart Offsite Backup Manager from service"
    rm -rf "/Library/StartupItems/netpartOBM-AutoUpdate"
fi

# remove existing scheduler service since it will be either created again or add into LaunchDaemon for MacOSX 10.10
# Remove Scheduler
if [ -e "/Library/StartupItems/netpartOBM" ]; then
    echo "Remove Scheduler for netpart Offsite Backup Manager from service"
    rm -rf "/Library/StartupItems/netpartOBM"
fi

# Remove Launch Daemons
if [ -e "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist" ]; then
    echo "Remove LaunchDaemons for com.netpartOBM.scheduler from service"
    launchctl unload "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
    rm -f "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
fi

# Remove all Launch Daemons that linked to same target
LINK_RESULT="`find \"/Library/LaunchDaemons\" -type l -lname \"${APP_HOME}/bin/com.cb.scheduler.plist\"`"
OIFS=$IFS
IFS=$'\n'
for word in ${LINK_RESULT}
do
    LINK_PATH="${word}"
    if [ -e "${LINK_PATH}" ]; then
        echo "Remove LaunchDaemons ${LINK_PATH}"
        launchctl unload "${LINK_PATH}"
        rm -f "${LINK_PATH}"
    fi
done
IFS=$OIFS

OS_VER=$(/usr/bin/sw_vers -productVersion)
echo "Current OS version $OS_VER"

# load into an array
# array=(${OS_VER//./ })
IFS='.'
array=($OS_VER)
IFS=$OIFS

# if ([[ "${array[0]}" -ge 10 ]] && [[ "${array[1]}" -ge 10 ]]); then
if ([[ "${array[0]}" -gt 10 ]] || ([[ "${array[0]}" -eq 10 ]] && [[ "${array[1]}" -ge 10 ]])); then
	echo "Create Launch Daemons : Scheduler for netpart Offsite Backup Manager"
	ln -sf "${APP_HOME}/bin/com.cb.scheduler.plist" "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
	chown root:wheel "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
	chmod 755 "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
	launchctl load "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
	echo "Launch Daemons created at /Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
else
	echo "Create StartupItem : Scheduler for netpart Offsite Backup Manager"
	if [ ! -d "/Library/StartupItems" ]; then
		mkdir "/Library/StartupItems"
	fi
	mkdir "/Library/StartupItems/netpartOBM"
	cd "${APP_HOME}/bin/netpartOBM"
	cp -R * "/Library/StartupItems/netpartOBM/"
	chown -R root:wheel "/Library/StartupItems/netpartOBM"
	echo "StartupItem Created at /Library/StartupItems/netpartOBM"
fi

