#!/bin/bash

# uninstall logic for netpart Offsite Backup Manager 9.3.2.0
# The root privilege is required to uninstall the application

###############################################################################
#             S H U T - D O W N                 S E R V I C E S               #
###############################################################################

# Shutdown Scheduler
if [ -e "/Applications/netpartOBM.app/ipc/Scheduler/running" ]; then
    echo "Shutdown Scheduler for netpart Offsite Backup Manager"
    touch "/Applications/netpartOBM.app/ipc/Scheduler/stop"
    echo "Wait 5 seconds before Scheduler exits"
    sleep 5
fi

# Shutdown AutoUpdateAgent
#if [ -e "/Applications/netpartOBM/aua/bin" ]; then
#    echo "Shutdown AutoUpdateAgent for netpart Offsite Backup Manager"
#    sh "/Applications/netpartOBM/aua/bin/shutdown.sh"
#    echo "Wait 5 seconds before AutoUpdateAgent exits"
#    sleep 5
#fi

###############################################################################
#        T A S K K I L L       A L L      J A V A       P R O C E S S         #
###############################################################################

# Kill all running process
sh "/Applications/netpartOBM.app/bin/taskkill" "/Applications/netpartOBM.app/jvm/bin/bJW"
sh "/Applications/netpartOBM.app/bin/taskkill" "/Applications/netpartOBM.app/jvm/bin/bschJW"
sh "/Applications/netpartOBM.app/bin/taskkill" "/Applications/netpartOBM.app/jvm/bin/java"


###############################################################################
#                 R E M O V E                   S E R V I C E S               #
###############################################################################

# Remove Scheduler
if [ -e "/Library/StartupItems/netpartOBM" ]; then
    echo "Remove Scheduler for netpart Offsite Backup Manager from service"
    rm -rf "/Library/StartupItems/netpartOBM"
fi

# Remove Launch Daemons
if [ -e "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist" ]; then
    echo "Remove LaunchDaemons for com.netpartOBM.scheduler from service"
    launchctl unload "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
    rm -f "/Library/LaunchDaemons/com.netpartOBM.scheduler.plist"
fi
# Remove AutoUpdateAgent
#if [ -e "/Library/StartupItems/netpartOBM-AutoUpdate" ]; then
#    echo "Remove AutoUpdateAgent for netpart Offsite Backup Manager from service"
#    rm -rf "/Library/StartupItems/netpartOBM-AutoUpdate"
#fi

###############################################################################
#      R E M O V E        U S E R         D E S K T O P      L I N K          #
###############################################################################

# Remove Desktop Symbolic Link
find /Users -name Desktop -type d -maxdepth 3 -mindepth 2 | while read DESKTOP_PATH;
do
    if [ -e "${DESKTOP_PATH}/netpartOBM" ]; then
        echo "Remove Desktop Link netpartOBM from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpartOBM"
        echo "Removed netpartOBM Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/netpart Offsite Backup Manager" ]; then
        echo "Remove Desktop Link netpart Offsite Backup Manager from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpart Offsite Backup Manager"
        echo "Removed netpart Offsite Backup Manager Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/netpartOBM" ]; then
        echo "Remove Desktop Link netpartOBM from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpartOBM"
        echo "Removed netpartOBM Desktop Link"
    fi

done

###############################################################################
#       R E M O V E        F I R E W A L L        R U L E                     #
###############################################################################

echo "Remove firewall rule"
sh "/Applications/netpartOBM.app/bin/UpdateFirewallRule.sh" "/Applications/netpartOBM.app/Contents/MacOS/netpartOBM" false

###############################################################################
#        R E M O V E           A P P L I C A T I O N           H O M E        #
###############################################################################

# Remove netpart Offsite Backup Manager
cd /
if [ -e "/Applications/netpartOBM.app" ]; then
    echo "Remove netpartOBM from Your Mac OS X"
    rm -rf "/Applications/netpartOBM.app"
fi

###############################################################################
#        R E M O V E             M A C     O S        R E C E I P T S         #
###############################################################################

# Remove Mac OS X Receipts
if [ -e "/Library/Receipts/obm-mac.pkg" ]; then
    echo "Remove Mac OS X Receipt for obm-mac.pkg (Path: /Library/Receipts/obm-mac.pkg)"
    rm -rf "/Library/Receipts/obm-mac.pkg"
fi