#!/bin/bash

# uninstall logic for netpart A-Click Backup 9.3.2.0
# The root privilege is required to uninstall the application

###############################################################################
#             S H U T - D O W N                 S E R V I C E S               #
###############################################################################

# Shutdown Scheduler
if [ -e "/Applications/netpartACB.app/ipc/Scheduler/running" ]; then
    echo "Shutdown Scheduler for netpart A-Click Backup"
    touch "/Applications/netpartACB.app/ipc/Scheduler/stop"
    echo "Wait 5 seconds before Scheduler exits"
    sleep 5
fi

# Shutdown AutoUpdateAgent
#if [ -e "/Applications/netpartACB/aua/bin" ]; then
#    echo "Shutdown AutoUpdateAgent for netpart A-Click Backup"
#    sh "/Applications/netpartACB/aua/bin/shutdown.sh"
#    echo "Wait 5 seconds before AutoUpdateAgent exits"
#    sleep 5
#fi

###############################################################################
#        T A S K K I L L       A L L      J A V A       P R O C E S S         #
###############################################################################

# Kill all running process
sh "/Applications/netpartACB.app/bin/taskkill" "/Applications/netpartACB.app/jvm/bin/bJW"
sh "/Applications/netpartACB.app/bin/taskkill" "/Applications/netpartACB.app/jvm/bin/bschJW"
sh "/Applications/netpartACB.app/bin/taskkill" "/Applications/netpartACB.app/jvm/bin/java"


###############################################################################
#                 R E M O V E                   S E R V I C E S               #
###############################################################################

# Remove Scheduler
if [ -e "/Library/StartupItems/netpartACB" ]; then
    echo "Remove Scheduler for netpart A-Click Backup from service"
    rm -rf "/Library/StartupItems/netpartACB"
fi

# Remove Launch Daemons
if [ -e "/Library/LaunchDaemons/com.netpartACB.scheduler.plist" ]; then
    echo "Remove LaunchDaemons for com.netpartACB.scheduler from service"
    launchctl unload "/Library/LaunchDaemons/com.netpartACB.scheduler.plist"
    rm -f "/Library/LaunchDaemons/com.netpartACB.scheduler.plist"
fi
# Remove AutoUpdateAgent
#if [ -e "/Library/StartupItems/netpartACB-AutoUpdate" ]; then
#    echo "Remove AutoUpdateAgent for netpart A-Click Backup from service"
#    rm -rf "/Library/StartupItems/netpartACB-AutoUpdate"
#fi

###############################################################################
#      R E M O V E        U S E R         D E S K T O P      L I N K          #
###############################################################################

# Remove Desktop Symbolic Link
find /Users -name Desktop -type d -maxdepth 3 -mindepth 2 | while read DESKTOP_PATH;
do
    if [ -e "${DESKTOP_PATH}/netpartACB" ]; then
        echo "Remove Desktop Link netpartACB from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpartACB"
        echo "Removed netpartACB Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/netpart A-Click Backup" ]; then
        echo "Remove Desktop Link netpart A-Click Backup from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpart A-Click Backup"
        echo "Removed netpart A-Click Backup Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/netpartACB" ]; then
        echo "Remove Desktop Link netpartACB from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/netpartACB"
        echo "Removed netpartACB Desktop Link"
    fi

done

###############################################################################
#       R E M O V E        F I R E W A L L        R U L E                     #
###############################################################################

echo "Remove firewall rule"
sh "/Applications/netpartACB.app/bin/UpdateFirewallRule.sh" "/Applications/netpartACB.app/Contents/MacOS/netpartACB" false

###############################################################################
#        R E M O V E           A P P L I C A T I O N           H O M E        #
###############################################################################

# Remove netpart A-Click Backup
cd /
if [ -e "/Applications/netpartACB.app" ]; then
    echo "Remove netpartACB from Your Mac OS X"
    rm -rf "/Applications/netpartACB.app"
fi

###############################################################################
#        R E M O V E             M A C     O S        R E C E I P T S         #
###############################################################################

# Remove Mac OS X Receipts
if [ -e "/Library/Receipts/acb-mac.pkg" ]; then
    echo "Remove Mac OS X Receipt for acb-mac.pkg (Path: /Library/Receipts/acb-mac.pkg)"
    rm -rf "/Library/Receipts/acb-mac.pkg"
fi